<?php
/*
* 2007-2010 PrestaShop 
*
* NOTICE OF LICENSE
*
* This source file is subject to the Open Software License (OSL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/osl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author Prestashop SA <contact@prestashop.com>
*  @copyright  2007-2010 Prestashop SA
*  @version  Release: $Revision: 1.4 $
*  @license    http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
*  International Registred Trademark & Property of PrestaShop SA
*/

if (!defined('_CAN_LOAD_FILES_'))
	exit;

class BlockSearchCenter extends Module
{
	public function __construct()
	{
		$this->name = 'blocksearchcenter';
		$this->tab = 'search_filter';
		$this->version = 1.0;

		parent::__construct();
		
		$this->displayName = $this->l('Quick Search block (center column)');
		$this->description = '';
	}

	public function install()
	{
		Db::getInstance()->Execute('
		INSERT IGNORE INTO `'._DB_PREFIX_.'hook` (`name`, `title`, `position`)
		VALUES ("centerColumn", "Center Column", 1)');
		return (parent::install() AND $this->registerHook('header') AND $this->registerHook('centerColumn'));
	}

	public function hookHeader($params)
	{
		global $smarty;
		$smarty->assign('HOOK_CENTER_COLUMN', Module::hookExec('centerColumn'));
	}
	
	public function hookCenterColumn($params)
	{
		global $smarty;
		
		$smarty->assign('ENT_QUOTES', ENT_QUOTES);
		$smarty->assign('search_ssl', (int)(isset($_SERVER['HTTPS']) && !empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] != 'off'));
		
		$ajaxSearch = (int)Configuration::get('PS_SEARCH_AJAX');
		$smarty->assign('ajaxsearch', $ajaxSearch);

		$instantSearch = (int)Configuration::get('PS_INSTANT_SEARCH');
		$smarty->assign('instantsearch', $instantSearch);
		if ($ajaxSearch)
		{
			Tools::addCSS(_PS_CSS_DIR_.'jquery.autocomplete.css');
			Tools::addJS(_PS_JS_DIR_.'jquery/jquery.autocomplete.js');
		}
		Tools::addCSS(_THEME_CSS_DIR_.'product_list.css');
		Tools::addCSS($this->_path.'blocksearch.css', 'all');
		return $this->display(__FILE__, 'blocksearchcenter.tpl');
	}
}
